﻿/* Skript zur Demonstration von UPDATE-Anweisungen
 * Als Benutzer SCOTT ausführen
 */
 

-- Einfache UPDATE-Anweisung
select ename, job, sal, comm
  from emp
 where job = 'SALESMAN';
 
update emp
   set sal = sal - 50,
       comm = comm * 1.1
 where job = 'SALESMAN';
 
select ename, job, sal, comm
  from emp
 where job = 'SALESMAN';
 
rollback;

-- UPDATE Anweisung mit Unterabfrage
update emp e
   set sal = (select min(sal)
                from emp
               where job = e.job);
               
select deptno, ename, job, sal
  from emp;
  
rollback;


-- Diskussion: Aktualisierung einer lückenlosen Zahlenfolge
-- als Benutzer HR ausführen
-- Beispieltabelle erzeugen
drop table prod_table;
create table prod_table as
select prod_id + (1000 * (lvl - 1)) prod_id, prod_name, prod_desc, prod_total_id
  from products
 cross join (select rownum lvl from all_objects where rownum <= 1000);
 
-- Beispieldaten
select *
  from prod_table
 where rownum < 5;
 
-- Erster Versuch
explain plan for
update prod_table p
   set prod_id = 
       (select rownum
          from prod_table pt
         where pt.prod_id = p.prod_id);
 
-- Zweiter Versuch
explain plan for
update prod_table p
   set prod_total_id = 
       (select rn
          from (select prod_id, rownum rn
                  from prod_table) pt
         where pt.prod_id = p.prod_id);
         
-- Dritter Versuch, mit Sortierung
explain plan for
update prod_table p
   set prod_total_id = 
       (select rownum
          from (select prod_id
                  from prod_table
                 order by prod_id) pt
         where pt.prod_id = p.prod_id);

-- oder, mit analytischen Funktionen
explain plan for
update prod_table p
   set prod_total_id = 
       (select rn
          from (select prod_id, row_number() over (order by prod_id) rn
                  from prod_table) pt
         where pt.prod_id = p.prod_id);
